<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Plan;

class PlanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
       $plans = array(
        array('id' => '1','title' => 'Basic','short_description' => 'Save ~20% when billed yearly','description' => 'For newcomers exploring, with limited features.','price' => '10','is_featured' => '0','is_recommended' => '1','is_trial' => '1','status' => '1','days' => '30','trial_days' => '7','data' => '{"devices":{"value":2,"overview":"2 Devices"},"web_messages":{"value":1000,"overview":"1000 Messages per month WA API"},"cloud_messages":{"value":1000,"overview":"1000 Messages per month WA Cloud API"},"chat_flow":{"value":1,"overview":"1 chat flow"},"custom_template":{"value":10,"overview":"10 custom templates"},"credits":{"value":100,"overview":"100 AI Credits"},"storage":{"value":1,"overview":"1 GB Storage"},"workspaces":{"value":2,"overview":"2 workspaces"},"team_members":{"value":3,"overview":"3 Team members"},"ai_training":{"value":10,"overview":"10 AI Training Dataset"},"web_scrape":{"value":10,"overview":"10 Queries for phone number scrap"},"apps":{"value":2,"overview":"2 API endpoints"},"contacts":{"value":10,"overview":"10 Custom Contacts"},"number_scanner":{"value":10,"overview":"10 Queries for WhatsApp number scan"},"campaign":{"value":true,"overview":"Campaign Marketing"},"auto_reply":{"value":true,"overview":"Auto Reply"},"quick_reply":{"value":true,"overview":"Quick Reply"},"modules":{"value":["Number Checker","Q A Reply","Web Scraping","Flow","Whatsapp Web","Whatsapp"],"overview":"All Modules Access"}}','extra_data' => NULL,'last_synced_at' => NULL,'created_at' => '2025-03-18 02:02:19','updated_at' => '2025-05-13 00:41:58'),
        array('id' => '2','title' => 'Basic','short_description' => 'Save ~20% when billed yearly','description' => 'For newcomers exploring, with limited features.','price' => '96','is_featured' => '0','is_recommended' => '0','is_trial' => '0','status' => '1','days' => '365','trial_days' => NULL,'data' => '{"devices":{"value":2,"overview":"2 Devices"},"chat_flow":{"value":1,"overview":"1 chat flow"},"custom_template":{"value":10,"overview":"10 custom templates"},"credits":{"value":100,"overview":"100 AI Credits"},"storage":{"value":1,"overview":"1 GB Storage"},"workspaces":{"value":2,"overview":"2 workspaces"},"team_members":{"value":3,"overview":"3 Team members"},"ai_training":{"value":10,"overview":"10 AI Training Dataset"},"web_scrape":{"value":10,"overview":"10 Queries for phone number scrap"},"apps":{"value":2,"overview":"2 API endpoints"},"contacts":{"value":10,"overview":"10 Custom Contacts"},"number_scanner":{"value":10,"overview":"10 Queries for WhatsApp number scan"},"campaign":{"value":true,"overview":"Campaign Marketing"},"auto_reply":{"value":true,"overview":"Auto Reply"},"quick_reply":{"value":true,"overview":"Quick Reply"},"modules":{"value":["Number Checker","Q A Reply","Web Scraping","Whatsapp","Whatsapp Web"],"overview":"All Modules Access"}}','extra_data' => NULL,'last_synced_at' => NULL,'created_at' => '2025-03-18 02:02:19','updated_at' => '2025-03-18 02:02:19'),
        array('id' => '3','title' => 'Basic','short_description' => 'Save ~20% Off','description' => 'For newcomers exploring, with limited features.','price' => '500','is_featured' => '0','is_recommended' => '0','is_trial' => '0','status' => '1','days' => '99999','trial_days' => NULL,'data' => '{"devices":{"value":2,"overview":"2 Devices"},"chat_flow":{"value":1,"overview":"1 chat flow"},"custom_template":{"value":10,"overview":"10 custom templates"},"credits":{"value":100,"overview":"100 AI Credits"},"storage":{"value":1,"overview":"1 GB Storage"},"workspaces":{"value":2,"overview":"2 workspaces"},"team_members":{"value":3,"overview":"3 Team members"},"ai_training":{"value":10,"overview":"10 AI Training Dataset"},"web_scrape":{"value":10,"overview":"10 Queries for phone number scrap"},"apps":{"value":2,"overview":"2 API endpoints"},"contacts":{"value":10,"overview":"10 Custom Contacts"},"number_scanner":{"value":10,"overview":"10 Queries for WhatsApp number scan"},"campaign":{"value":true,"overview":"Campaign Marketing"},"auto_reply":{"value":true,"overview":"Auto Reply"},"quick_reply":{"value":true,"overview":"Quick Reply"},"modules":{"value":["Number Checker","Q A Reply","Web Scraping","Whatsapp","Whatsapp Web"],"overview":"All Modules Access"}}','extra_data' => NULL,'last_synced_at' => NULL,'created_at' => '2025-03-18 02:02:19','updated_at' => '2025-03-18 02:02:19'),
        array('id' => '5','title' => 'Pro','short_description' => 'Save ~20% when billed yearly','description' => 'Seamless All access expanded capabilities.','price' => '192','is_featured' => '0','is_recommended' => '0','is_trial' => '0','status' => '1','days' => '365','trial_days' => NULL,'data' => '{"devices":{"value":5,"overview":"5 Devices"},"chat_flow":{"value":5,"overview":"5 chat flow"},"custom_template":{"value":20,"overview":"20 custom templates"},"credits":{"value":200,"overview":"200 AI Credits"},"storage":{"value":1,"overview":"1 GB Storage"},"workspaces":{"value":10,"overview":"10 workspaces"},"team_members":{"value":10,"overview":"10 Team members"},"ai_training":{"value":20,"overview":"20 Training Dataset"},"web_scrape":{"value":20,"overview":"20 Queries for phone number scrap"},"apps":{"value":20,"overview":"20 API endpoints"},"contacts":{"value":20,"overview":"20 Custom Contacts"},"number_scanner":{"value":20,"overview":"20 Queries for WhatsApp number scan"},"campaign":{"value":true,"overview":"Campaign Marketing"},"auto_reply":{"value":true,"overview":"Auto Reply"},"quick_reply":{"value":true,"overview":"Quick Reply"},"modules":{"value":["Number Checker","Q A Reply","Web Scraping","Whatsapp","Whatsapp Web"],"overview":"All Modules Access"}}','extra_data' => NULL,'last_synced_at' => NULL,'created_at' => '2025-03-18 02:02:19','updated_at' => '2025-03-18 02:02:19'),
        array('id' => '6','title' => 'Pro','short_description' => 'Save ~20% Off','description' => 'Seamless All access expanded capabilities.','price' => '600','is_featured' => '0','is_recommended' => '0','is_trial' => '0','status' => '1','days' => '99999','trial_days' => NULL,'data' => '{"devices":{"value":5,"overview":"5 Devices"},"chat_flow":{"value":5,"overview":"5 chat flow"},"custom_template":{"value":20,"overview":"20 custom templates"},"credits":{"value":200,"overview":"200 AI Credits"},"storage":{"value":1,"overview":"1 GB Storage"},"workspaces":{"value":10,"overview":"10 workspaces"},"team_members":{"value":10,"overview":"10 Team members"},"ai_training":{"value":20,"overview":"20 Training Dataset"},"web_scrape":{"value":20,"overview":"20 Queries for phone number scrap"},"apps":{"value":20,"overview":"20 API endpoints"},"contacts":{"value":20,"overview":"20 Custom Contacts"},"number_scanner":{"value":20,"overview":"20 Queries for WhatsApp number scan"},"campaign":{"value":true,"overview":"Campaign Marketing"},"auto_reply":{"value":true,"overview":"Auto Reply"},"quick_reply":{"value":true,"overview":"Quick Reply"},"modules":{"value":["Number Checker","Q A Reply","Web Scraping","Whatsapp","Whatsapp Web","Flow"],"overview":"All Modules Access"}}','extra_data' => NULL,'last_synced_at' => '2025-05-10 07:57:03','created_at' => '2025-03-18 02:02:19','updated_at' => '2025-05-10 07:57:03'),
        array('id' => '7','title' => 'Enterprise','short_description' => 'Save ~20% when billed yearly','description' => 'Seamless unlimited-access, expanded capabilities.','price' => '99','is_featured' => '0','is_recommended' => '0','is_trial' => '0','status' => '1','days' => '30','trial_days' => '0','data' => '{"devices":{"value":-1,"overview":"Unlimited Chat Automation"},"web_messages":{"value":-1,"overview":"Unlimited messages for WA Web"},"cloud_messages":{"value":-1,"overview":"Unlimited messages for WA Cloud"},"chat_flow":{"value":-1,"overview":"Unlimited Template"},"custom_template":{"value":-1,"overview":"Monthly 200 AI Credits"},"credits":{"value":200,"overview":"1 GB Storage"},"storage":{"value":1,"overview":"Unlimited Templates"},"workspaces":{"value":-1,"overview":"Unlimited Team Members"},"team_members":{"value":-1,"overview":"Unlimited AI Training"},"ai_training":{"value":-1,"overview":"Monthly 100 Request for Web Scrap"},"web_scrape":{"value":100,"overview":"Unlimited REST API"},"apps":{"value":-1,"overview":"Unlimited Custom Contacts"},"contacts":{"value":-1,"overview":"Unlimited WA Number Scan"},"number_scanner":{"value":-1,"overview":"Campaign"},"campaign":{"value":true,"overview":"Auto Reply \\/ Chatbot"},"auto_reply":{"value":true,"overview":"Auto Reply"},"quick_reply":{"value":true,"overview":"Pre messages"},"modules":{"value":["Flow","Number Checker","Q A Reply","Web Scraping","Whatsapp","Whatsapp E S","Whatsapp Web"],"overview":"All Modules Access"}}','extra_data' => NULL,'last_synced_at' => '2025-05-10 11:22:40','created_at' => '2025-05-10 10:03:26','updated_at' => '2025-07-29 18:03:18'),
        array('id' => '8','title' => 'Pro','short_description' => 'Save ~20% when billed yearly','description' => 'Seamless all access expanded capabilities.','price' => '20','is_featured' => '0','is_recommended' => '0','is_trial' => '0','status' => '1','days' => '30','trial_days' => '0','data' => '{"devices":{"value":5,"overview":"5 Devices"},"web_messages":{"value":2000,"overview":"2000 Messages per month WA API"},"cloud_messages":{"value":2000,"overview":"2000 Messages per month WA Cloud API"},"chat_flow":{"value":5,"overview":"5 chat flow"},"custom_template":{"value":20,"overview":"20 custom templates"},"credits":{"value":200,"overview":"200 AI Credits"},"storage":{"value":1,"overview":"1 GB Storage"},"workspaces":{"value":2,"overview":"2 workspaces"},"team_members":{"value":3,"overview":"3 Team members"},"ai_training":{"value":10,"overview":"10 AI Training Dataset"},"web_scrape":{"value":20,"overview":"20 Queries for phone number scrap"},"apps":{"value":5,"overview":"5 API endpoints"},"contacts":{"value":50,"overview":"50 Custom Contacts"},"number_scanner":{"value":50,"overview":"50 Queries for WhatsApp number scan"},"campaign":{"value":true,"overview":"Campaign Marketing"},"auto_reply":{"value":true,"overview":"Auto Reply"},"quick_reply":{"value":true,"overview":"Quick Reply"},"modules":{"value":["Flow","Number Checker","Q A Reply","Web Scraping","Whatsapp E S","Whatsapp","Whatsapp Web"],"overview":"All Modules Access"}}','extra_data' => NULL,'last_synced_at' => NULL,'created_at' => '2025-07-29 17:36:25','updated_at' => '2025-07-29 17:37:29'),
        array('id' => '9','title' => 'Enterprise','short_description' => 'Save ~20% when billed yearly','description' => 'Seamless unlimited-access, expanded capabilities.','price' => '950','is_featured' => '0','is_recommended' => '0','is_trial' => '0','status' => '1','days' => '365','trial_days' => '0','data' => '{"devices":{"value":-1,"overview":"Unlimited Chat Automation"},"web_messages":{"value":-1,"overview":"Unlimited messages for WA Web"},"cloud_messages":{"value":-1,"overview":"Unlimited messages for WA Cloud"},"chat_flow":{"value":-1,"overview":"Unlimited Chat Flow Builder"},"custom_template":{"value":-1,"overview":"Unlimited Template"},"credits":{"value":500,"overview":"500 AI Credits"},"storage":{"value":1,"overview":"1 GB Storage"},"workspaces":{"value":-1,"overview":"Unlimited Workspaces"},"team_members":{"value":-1,"overview":"Unlimited Team Members"},"ai_training":{"value":-1,"overview":"Unlimited AI Training Dataset"},"web_scrape":{"value":100,"overview":"100 Queries Per month for phone number"},"apps":{"value":-1,"overview":"Unlimited Apps"},"contacts":{"value":-1,"overview":"Unlimited Custom Contacts"},"number_scanner":{"value":-1,"overview":"Unlimited WA Number Scanning"},"campaign":{"value":true,"overview":"Unlimited \\nCampaign"},"auto_reply":{"value":true,"overview":"Unlimited Auto Reply"},"quick_reply":{"value":true,"overview":"Unlimited Quick Reply"},"modules":{"value":["Flow","Number Checker","Q A Reply","Web Scraping","Whatsapp E S","Whatsapp","Whatsapp Web"],"overview":"Unlimited Chat Automation"}}','extra_data' => NULL,'last_synced_at' => NULL,'created_at' => '2025-07-29 18:11:06','updated_at' => '2025-07-29 18:11:06'),
        array('id' => '10','title' => 'Enterprise','short_description' => 'Save ~20% off','description' => 'Seamless unlimited-access, expanded capabilities.','price' => '1500','is_featured' => '0','is_recommended' => '0','is_trial' => '0','status' => '1','days' => '99999','trial_days' => '0','data' => '{"devices":{"value":-1,"overview":"Unlimited Chat Automation"},"web_messages":{"value":-1,"overview":"Unlimited messages for WA Web"},"cloud_messages":{"value":-1,"overview":"Unlimited messages for WA Cloud"},"chat_flow":{"value":-1,"overview":"Unlimited Chat Flow Builder"},"custom_template":{"value":-1,"overview":"Unlimited Template"},"credits":{"value":500,"overview":"500 AI Credits"},"storage":{"value":1,"overview":"1 GB Storage"},"workspaces":{"value":-1,"overview":"Unlimited Workspaces"},"team_members":{"value":-1,"overview":"Unlimited Team Members"},"ai_training":{"value":-1,"overview":"Unlimited AI Training Dataset"},"web_scrape":{"value":100,"overview":"100 Queries Per month for phone number"},"apps":{"value":-1,"overview":"Unlimited Apps"},"contacts":{"value":-1,"overview":"Unlimited Custom Contacts"},"number_scanner":{"value":-1,"overview":"Unlimited WA Number Scanning"},"campaign":{"value":true,"overview":"Unlimited \\nCampaign"},"auto_reply":{"value":true,"overview":"Unlimited Auto Reply"},"quick_reply":{"value":true,"overview":"Unlimited Quick Reply"},"modules":{"value":["Flow","Number Checker","Q A Reply","Web Scraping","Whatsapp E S","Whatsapp","Whatsapp Web"],"overview":"Unlimited Chat Automation"}}','extra_data' => NULL,'last_synced_at' => NULL,'created_at' => '2025-07-29 18:11:06','updated_at' => '2025-07-29 18:11:06')
        );
        Plan::insert($plans);
    }

}
